/*
 * Decompiled with CFR 0.152.
 */
package henson;

public class Float11 {
    public static final double SQRT3 = 1.7320508075688772;
    public static final double LOG10 = 2.302585092994046;

    public static double acos(double d) {
        double d2 = Float11.asin(d);
        if (d2 == Double.NaN) {
            return d2;
        }
        return 1.5707963267948966 - d2;
    }

    public static double asin(double d) {
        if (d < -1.0 || d > 1.0) {
            return Double.NaN;
        }
        if (d == -1.0) {
            return -1.5707963267948966;
        }
        if (d == 1.0) {
            return 1.5707963267948966;
        }
        return Float11.atan(d / Math.sqrt(1.0 - d * d));
    }

    public static double atan(double d) {
        double d2;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (d < 0.0) {
            d = -d;
            bl = true;
        }
        if (d > 1.0) {
            d = 1.0 / d;
            bl2 = true;
        }
        while (d > 0.2617993877991494) {
            ++n;
            d2 = d + 1.7320508075688772;
            d2 = 1.0 / d2;
            d *= 1.7320508075688772;
            d -= 1.0;
            d *= d2;
        }
        double d3 = d * d;
        d2 = d3 + 1.4087812;
        d2 = 0.55913709 / d2;
        d2 += 0.60310579;
        d2 -= d3 * 0.05160454;
        d2 *= d;
        while (n > 0) {
            d2 += 0.5235987755982988;
            --n;
        }
        if (bl2) {
            d2 = 1.5707963267948966 - d2;
        }
        if (bl) {
            d2 = -d2;
        }
        return d2;
    }

    public static double atan2(double d, double d2) {
        if (d2 == Double.NaN) {
            return Double.NaN;
        }
        double d3 = Float11.atan(d / d2);
        if (d > 0.0 && d2 < 0.0) {
            d3 += Math.PI;
        }
        if (d < 0.0 && d2 < 0.0) {
            d3 -= Math.PI;
        }
        return d3;
    }

    public static double exp(double d) {
        boolean bl;
        if (d == 0.0) {
            return 1.0;
        }
        double d2 = 1.0;
        long l = 1L;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        double d3 = d / (double)l;
        for (long i = 2L; i < 50L; ++i) {
            d2 += d3;
            d3 = d3 * d / (double)i;
        }
        if (bl) {
            return 1.0 / d2;
        }
        return d2;
    }

    private static double _log(double d) {
        double d2;
        if (!(d > 0.0)) {
            return Double.NaN;
        }
        double d3 = 0.0;
        double d4 = d - 1.0;
        double d5 = d + 1.0;
        double d6 = d2 = d4 / d5;
        d5 = d6 * d2;
        for (long i = 1L; i < 50L; i += 2L) {
            d3 += d6 / (double)i;
            d6 *= d5;
        }
        return d3 * 2.0;
    }

    public static double log(double d) {
        if (!(d > 0.0)) {
            return Double.NaN;
        }
        boolean bl = false;
        double d2 = Float11._log(0.5);
        if (d < 0.0) {
            bl = true;
            d = -d;
        }
        int n = 0;
        while (d > 1.0) {
            d /= 2.0;
            ++n;
        }
        double d3 = Float11._log(d);
        for (int i = 0; i < n; ++i) {
            d3 -= d2;
        }
        if (bl) {
            return 1.0 / d3;
        }
        return d3;
    }

    public static double log10(double d) {
        if (!(d > 0.0)) {
            return Double.NaN;
        }
        boolean bl = false;
        double d2 = Float11._log(0.5);
        if (d < 0.0) {
            bl = true;
            d = -d;
        }
        int n = 0;
        if (d > 1.0) {
            while (d > 1.0) {
                d /= 10.0;
                ++n;
            }
        } else {
            while (d < 1.0) {
                d *= 10.0;
                --n;
            }
        }
        double d3 = n;
        if (d != 1.0) {
            d3 += Float11.log(d) / 2.302585092994046;
        }
        if (bl) {
            return 1.0 / d3;
        }
        return d3;
    }

    public static double pow(double d, double d2) {
        boolean bl;
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return 1.0;
        }
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d2 == 1.0) {
            return d;
        }
        long l = (long)Math.floor(d2);
        boolean bl2 = bl = d2 == (double)l;
        if (bl) {
            boolean bl3 = false;
            if (d2 < 0.0) {
                bl3 = true;
            }
            double d3 = d;
            for (long i = 1L; i < (bl3 ? -l : l); ++i) {
                d3 *= d;
            }
            if (bl3) {
                return 1.0 / d3;
            }
            return d3;
        }
        if (d > 0.0) {
            return Float11.exp(d2 * Float11.log(d));
        }
        return Double.NaN;
    }
}

