/*
 * Decompiled with CFR 0.152.
 */
package net.zehnkampf.Deca2Go;

import henson.Float11;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import net.zehnkampf.Deca2Go.Deca2Go;
import net.zehnkampf.Deca2Go.Mehrkampf;

public class FuenfkampfF
extends Mehrkampf
implements CommandListener,
ItemStateListener {
    private final int disciplines;
    private String[] disz = new String[]{"60 m H\u00fcrden", "Hochsprung", "Kugelsto\u00df", "Weitsprung", "800 m"};
    private String[] unit = new String[]{"s", "m", "m", "m", "min"};
    private int[] il = new int[]{6, 4, 5, 4, 8};
    private double[] a = new double[]{20.0479, 1.84523, 56.0211, 0.188807, 0.11193};
    private double[] b = new double[]{17.0, 0.75, 1.5, 2.1, 254.0};
    private double[] c = new double[]{1.835, 1.348, 1.05, 1.41, 1.88};
    private int[] f = new int[]{1, 100, 1, 100, 1};
    private double[] inc = new double[]{0.24, 0.0, 0.0, 0.0, 0.0};
    private TextField[] tf = new TextField[5];
    private StringItem[] si = new StringItem[5];
    private StringItem tot;
    private int total = 0;
    private final Command calcCmd = new Command("Calc", 1, 1);
    private final Command backCmd = new Command("Zur\u00fcck", 2, 2);

    public FuenfkampfF() {
        super("Deca2Go: Hallen-F\u00fcnfkampf (F)");
        this.disciplines = 5;
        this.tot = new StringItem(null, "Gesamt: 0 Punkte");
        this.append((Item)this.tot);
        for (int i = 0; i < 5; ++i) {
            this.tf[i] = new TextField(this.disz[i] + " [" + this.unit[i] + "]: ", "", this.il[i], 0);
            this.si[i] = new StringItem(null, "0 Punkte");
            this.append((Item)this.tf[i]);
            this.append((Item)this.si[i]);
        }
        this.addCommand(this.backCmd);
        this.addCommand(this.calcCmd);
        this.setCommandListener(this);
        this.setItemStateListener(this);
    }

    public void itemStateChanged(Item item) {
        this.calculate();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCmd) {
            Deca2Go.getInstance().showMain();
            return;
        }
        this.calculate();
    }

    public void calculate() {
        this.total = 0;
        for (int i = 0; i < 5; ++i) {
            try {
                double d = 0.0;
                String string = this.tf[i].getString().trim();
                if (string.equals("") || string == null) continue;
                string = string.replace(',', '.');
                if ((string = string.replace(':', '.')).endsWith("h")) {
                    string = string.substring(0, string.length() - 1);
                    d = Double.parseDouble(string) + this.inc[i];
                } else {
                    d = Double.parseDouble(string);
                }
                if (this.unit[i].equals("min")) {
                    d = (double)((long)d * 60L) + 100.0 * (d - (double)((long)d));
                }
                int n = (int)(this.a[i] * Float11.pow(Math.abs(d - this.b[i]) * (double)this.f[i], this.c[i]));
                this.total += n;
                this.si[i].setText(Integer.toString(n) + " Punkte");
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.tot.setText("Gesamt: " + this.total + " Punkte");
        Display.getDisplay((MIDlet)Deca2Go.getInstance()).setCurrent((Displayable)this);
    }

    public int getNumberOfDisciplines() {
        return 5;
    }

    public String getUserInput(int n) {
        return this.tf[n].getString().trim();
    }

    public void setUserInput(int n, String string) {
        this.tf[n].setString(string);
    }
}

