/*
 * Decompiled with CFR 0.152.
 */
package net.zehnkampf.Deca2Go;

import henson.Float11;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import net.zehnkampf.Deca2Go.Deca2Go;
import net.zehnkampf.Deca2Go.Mehrkampf;

public class SiebenkampfM
extends Mehrkampf
implements CommandListener,
ItemStateListener {
    private final int disciplines;
    private String[] disz = new String[]{"60 m", "Weitsprung", "Kugelsto\u00df", "Hochsprung", "60 m H\u00fcrden", "Stabhochsprung", "1000 m"};
    private String[] unit = new String[]{"s", "m", "m", "m", "s", "m", "min"};
    private int[] il = new int[]{6, 4, 5, 4, 6, 4, 8};
    private double[] a = new double[]{58.015, 0.14354, 51.39, 0.8465, 20.5173, 0.2797, 0.08713};
    private double[] b = new double[]{11.5, 2.2, 1.5, 0.75, 15.5, 1.0, 305.5};
    private double[] c = new double[]{1.81, 1.4, 1.05, 1.42, 1.92, 1.35, 1.85};
    private int[] f = new int[]{1, 100, 1, 100, 1, 100, 1};
    private double[] inc = new double[]{0.24, 0.0, 0.0, 0.0, 0.24, 0.0, 0.0};
    private TextField[] tf = new TextField[7];
    private StringItem[] si = new StringItem[7];
    private StringItem tot;
    private int total = 0;
    private final Command calcCmd = new Command("Calc", 1, 1);
    private final Command backCmd = new Command("Zur\u00fcck", 2, 2);

    public SiebenkampfM() {
        super("Deca2Go: Siebenkampf (M)");
        this.disciplines = 7;
        this.tot = new StringItem(null, "Gesamt: 0 Punkte");
        this.append((Item)this.tot);
        for (int i = 0; i < 7; ++i) {
            this.tf[i] = new TextField(this.disz[i] + " [" + this.unit[i] + "]: ", "", this.il[i], 0);
            this.si[i] = new StringItem(null, "0 Punkte");
            this.append((Item)this.tf[i]);
            this.append((Item)this.si[i]);
        }
        this.addCommand(this.backCmd);
        this.addCommand(this.calcCmd);
        this.setCommandListener(this);
        this.setItemStateListener(this);
    }

    public void itemStateChanged(Item item) {
        this.calculate();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCmd) {
            Deca2Go.getInstance().showMain();
            return;
        }
        this.calculate();
    }

    public void calculate() {
        this.total = 0;
        for (int i = 0; i < 7; ++i) {
            try {
                double d = 0.0;
                String string = this.tf[i].getString().trim();
                if (string.equals("") || string == null) continue;
                string = string.replace(',', '.');
                if ((string = string.replace(':', '.')).endsWith("h")) {
                    string = string.substring(0, string.length() - 1);
                    d = Double.parseDouble(string) + this.inc[i];
                } else {
                    d = Double.parseDouble(string);
                }
                if (this.unit[i].equals("min")) {
                    d = (double)((long)d * 60L) + 100.0 * (d - (double)((long)d));
                }
                int n = (int)(this.a[i] * Float11.pow(Math.abs(d - this.b[i]) * (double)this.f[i], this.c[i]));
                this.total += n;
                this.si[i].setText(Integer.toString(n) + " Punkte");
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.tot.setText("Gesamt: " + this.total + " Punkte");
        Display.getDisplay((MIDlet)Deca2Go.getInstance()).setCurrent((Displayable)this);
    }

    public int getNumberOfDisciplines() {
        return 7;
    }

    public String getUserInput(int n) {
        return this.tf[n].getString().trim();
    }

    public void setUserInput(int n, String string) {
        this.tf[n].setString(string);
    }
}

