/*
 * Decompiled with CFR 0.152.
 */
package net.zehnkampf.Deca2Go;

import henson.Float11;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import net.zehnkampf.Deca2Go.Deca2Go;
import net.zehnkampf.Deca2Go.Mehrkampf;

public class ZehnkampfM
extends Mehrkampf
implements CommandListener,
ItemStateListener {
    private final int disciplines;
    private String[] unit = new String[]{"s", "m", "m", "m", "s", "s", "m", "m", "m", "min"};
    private String[] disz = new String[]{"100 m", "Weitsprung", "Kugelsto\u00df", "Hochsprung", "400 m", "110 m H\u00fcrden", "Diskuswurf", "Stabhochsprung", "Speerwurf", "1500 m"};
    private int[] il = new int[]{6, 4, 5, 4, 6, 6, 5, 4, 5, 8};
    private double[] a = new double[]{25.4347, 0.14354, 51.39, 0.8465, 1.53775, 5.74352, 12.91, 0.2797, 10.14, 0.03768};
    private double[] b = new double[]{18.0, 2.2, 1.5, 0.75, 82.0, 28.5, 4.0, 1.0, 7.0, 480.0};
    private double[] c = new double[]{1.81, 1.4, 1.05, 1.42, 1.81, 1.92, 1.1, 1.35, 1.08, 1.85};
    private int[] f = new int[]{1, 100, 1, 100, 1, 1, 1, 100, 1, 1};
    private double[] inc = new double[]{0.24, 0.0, 0.0, 0.0, 0.14, 0.24, 0.0, 0.0, 0.0, 0.0};
    private TextField[] tf = new TextField[10];
    private StringItem[] si = new StringItem[10];
    private StringItem tot;
    private int total = 0;
    private final Command calcCmd = new Command("Calc", 1, 1);
    private final Command backCmd = new Command("Zur\u00fcck", 2, 2);

    public ZehnkampfM() {
        super("Deca2Go: Zehnkampf (M)");
        this.disciplines = 10;
        this.tot = new StringItem(null, "Gesamt: 0 Punkte");
        this.append((Item)this.tot);
        for (int i = 0; i < 10; ++i) {
            this.tf[i] = new TextField(this.disz[i] + " [" + this.unit[i] + "]: ", "", this.il[i], 0);
            this.si[i] = new StringItem(null, "0 Punkte");
            this.append((Item)this.tf[i]);
            this.append((Item)this.si[i]);
        }
        this.addCommand(this.backCmd);
        this.addCommand(this.calcCmd);
        this.setCommandListener(this);
        this.setItemStateListener(this);
    }

    public void itemStateChanged(Item item) {
        this.calculate();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCmd) {
            Deca2Go.getInstance().showMain();
            return;
        }
        this.calculate();
    }

    public void calculate() {
        this.total = 0;
        for (int i = 0; i < 10; ++i) {
            try {
                double d = 0.0;
                String string = this.tf[i].getString().trim();
                if (string.equals("") || string == null) continue;
                string = string.replace(',', '.');
                if ((string = string.replace(':', '.')).endsWith("h")) {
                    string = string.substring(0, string.length() - 1);
                    d = Double.parseDouble(string) + this.inc[i];
                } else {
                    d = Double.parseDouble(string);
                }
                if (this.unit[i].equals("min")) {
                    d = (double)((long)d * 60L) + 100.0 * (d - (double)((long)d));
                }
                int n = (int)(this.a[i] * Float11.pow(Math.abs(d - this.b[i]) * (double)this.f[i], this.c[i]));
                this.total += n;
                this.si[i].setText(Integer.toString(n) + " Punkte");
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.tot.setText("Gesamt: " + this.total + " Punkte");
        Display.getDisplay((MIDlet)Deca2Go.getInstance()).setCurrent((Displayable)this);
    }

    public int getNumberOfDisciplines() {
        return 10;
    }

    public String getUserInput(int n) {
        return this.tf[n].getString().trim();
    }

    public void setUserInput(int n, String string) {
        this.tf[n].setString(string);
    }
}

